﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lambda/Lambda_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Lambda {
namespace Model {

/**
 * <p>Contains details about a callback operation that has started, including
 * timing information and callback metadata.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CallbackStartedDetails">AWS
 * API Reference</a></p>
 */
class CallbackStartedDetails {
 public:
  AWS_LAMBDA_API CallbackStartedDetails() = default;
  AWS_LAMBDA_API CallbackStartedDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_LAMBDA_API CallbackStartedDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_LAMBDA_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The callback ID. Callback IDs are generated by the
   * <code>DurableContext</code> when a durable function calls
   * <code>ctx.waitForCallback</code>.</p>
   */
  inline const Aws::String& GetCallbackId() const { return m_callbackId; }
  inline bool CallbackIdHasBeenSet() const { return m_callbackIdHasBeenSet; }
  template <typename CallbackIdT = Aws::String>
  void SetCallbackId(CallbackIdT&& value) {
    m_callbackIdHasBeenSet = true;
    m_callbackId = std::forward<CallbackIdT>(value);
  }
  template <typename CallbackIdT = Aws::String>
  CallbackStartedDetails& WithCallbackId(CallbackIdT&& value) {
    SetCallbackId(std::forward<CallbackIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The heartbeat timeout value, in seconds.</p>
   */
  inline int GetHeartbeatTimeout() const { return m_heartbeatTimeout; }
  inline bool HeartbeatTimeoutHasBeenSet() const { return m_heartbeatTimeoutHasBeenSet; }
  inline void SetHeartbeatTimeout(int value) {
    m_heartbeatTimeoutHasBeenSet = true;
    m_heartbeatTimeout = value;
  }
  inline CallbackStartedDetails& WithHeartbeatTimeout(int value) {
    SetHeartbeatTimeout(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timeout value, in seconds.</p>
   */
  inline int GetTimeout() const { return m_timeout; }
  inline bool TimeoutHasBeenSet() const { return m_timeoutHasBeenSet; }
  inline void SetTimeout(int value) {
    m_timeoutHasBeenSet = true;
    m_timeout = value;
  }
  inline CallbackStartedDetails& WithTimeout(int value) {
    SetTimeout(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_callbackId;

  int m_heartbeatTimeout{0};

  int m_timeout{0};
  bool m_callbackIdHasBeenSet = false;
  bool m_heartbeatTimeoutHasBeenSet = false;
  bool m_timeoutHasBeenSet = false;
};

}  // namespace Model
}  // namespace Lambda
}  // namespace Aws
