/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.values;

import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSMathValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.values.AnimatableNumericValue;
import org.w3c.dom.DOMException;

public class AnimatableCalcValue
extends AnimatableNumericValue {
    private CSSMathValue calc;

    public AnimatableCalcValue(AnimationTarget target, short type, CSSMathValue calc, short pcInterp) {
        super(target, type, pcInterp);
        this.calc = calc;
    }

    @Override
    public float getLengthValue() {
        CSSTypedValue result;
        Evaluator eval = new Evaluator(this.lengthType){

            protected float percentage(CSSTypedValue value, short resultType) throws DOMException {
                return AnimatableCalcValue.this.target.svgToUserSpace(value.getFloatValue((short)2), AnimatableCalcValue.this.lengthType, AnimatableCalcValue.this.percentageInterpretation);
            }
        };
        switch (this.calc.getPrimitiveType()) {
            case EXPRESSION: {
                result = eval.evaluateExpression((CSSExpressionValue)this.calc);
                break;
            }
            case MATH_FUNCTION: {
                result = eval.evaluateFunction((CSSMathFunctionValue)this.calc);
                break;
            }
            default: {
                throw new RuntimeException("Invalid result: " + this.calc.getCssText());
            }
        }
        float f = result.getFloatValue(result.getUnitType());
        if (this.lengthType != result.getUnitType() && result.getUnitType() != 0) {
            f = NumberValue.floatValueConversion((float)f, (short)result.getUnitType(), (short)this.lengthType);
        }
        return f;
    }
}

