/*
 * Decompiled with CFR 0.152.
 */
package tim.prune;

import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import tim.prune.DataStatus;
import tim.prune.FunctionLibrary;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.cmd.Command;
import tim.prune.config.Config;
import tim.prune.data.LatLonRectangle;
import tim.prune.data.RecentFile;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.function.media.BlockMultipleMediaDialog;
import tim.prune.function.media.LinkedMediaLoader;
import tim.prune.function.settings.SaveConfig;
import tim.prune.gui.IconManager;
import tim.prune.gui.SidebarController;
import tim.prune.gui.Viewport;
import tim.prune.gui.colour.ColourerCaretaker;
import tim.prune.gui.colour.PointColourer;
import tim.prune.load.FileLoader;
import tim.prune.load.ItemToLoad;
import tim.prune.load.JpegLoader;
import tim.prune.save.ExifSaver;
import tim.prune.save.FileSaver;
import tim.prune.tips.TipManager;
import tim.prune.undo.RedoManager;
import tim.prune.undo.UndoManager;
import tim.prune.undo.UndoStack;

public class App {
    private final JFrame _frame;
    private final Config _config;
    private final IconManager _iconManager;
    private final Track _track;
    private final TrackInfo _trackInfo;
    private int _lastSavePosition = 0;
    private SidebarController _sidebarController = null;
    private FileLoader _fileLoader = null;
    private LinkedMediaLoader _linkedMediaLoader = null;
    private JpegLoader _jpegLoader = null;
    private FileSaver _fileSaver = null;
    private final UndoStack _undoStack;
    private final UndoStack _redoStack;
    private final ColourerCaretaker _colCaretaker;
    private Viewport _viewport = null;
    private final ArrayList<ItemToLoad> _itemsToLoad = new ArrayList();
    private AppMode _appMode = AppMode.NORMAL;

    public App(JFrame jFrame, Config config) {
        this._frame = jFrame;
        this._config = config == null ? new Config() : config;
        this._iconManager = new IconManager(this._config.getConfigBoolean("prune.iconsdoublesize"));
        this._undoStack = new UndoStack();
        this._redoStack = new UndoStack();
        this._track = new Track();
        this._trackInfo = new TrackInfo(this._track);
        FunctionLibrary.initialise(this);
        this._colCaretaker = new ColourerCaretaker(this);
        UpdateMessageBroker.addSubscriber(this._colCaretaker);
        this._colCaretaker.setColourer(this._config.getPointColourer());
    }

    public TrackInfo getTrackInfo() {
        return this._trackInfo;
    }

    public JFrame getFrame() {
        return this._frame;
    }

    public boolean hasDataUnsaved() {
        return this._undoStack.size() > this._lastSavePosition && (this._track.getNumPoints() > 0 || this._trackInfo.getPhotoList().hasModifiedMedia());
    }

    public UndoStack getUndoStack() {
        return this._undoStack;
    }

    public UndoStack getRedoStack() {
        return this._redoStack;
    }

    public void updatePointColourer() {
        if (this._colCaretaker != null) {
            this._colCaretaker.setColourer(this._config.getPointColourer());
        }
    }

    public PointColourer getPointColourer() {
        return this._colCaretaker == null ? null : this._colCaretaker.getColourer();
    }

    public void showTip(int n) {
        String string = TipManager.fireTipTrigger(n);
        if (string != null && !string.isEmpty()) {
            JOptionPane.showMessageDialog(this._frame, I18nManager.getText(string), I18nManager.getText("tip.title"), 1);
        }
    }

    public void loadDataFiles(ArrayList<File> arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        for (File file : arrayList) {
            this._itemsToLoad.add(ItemToLoad.dataFile(file));
        }
        this.loadNextItem(false);
    }

    public void loadLinkedMedia(ArrayList<ItemToLoad> arrayList) {
        if (arrayList != null) {
            this._itemsToLoad.addAll(0, arrayList);
        }
    }

    public boolean execute(Command command) {
        if (command.execute(this._trackInfo)) {
            this._undoStack.add(command);
            this._redoStack.clear();
            UpdateMessageBroker.informSubscribers(command.getConfirmText());
            UpdateMessageBroker.informSubscribers(command.getUpdateFlags());
            return true;
        }
        return false;
    }

    public void openFile() {
        if (this._fileLoader == null) {
            this._fileLoader = new FileLoader(this);
        }
        this._fileLoader.openFile();
    }

    public void addPhotos() {
        if (this._jpegLoader == null) {
            this._jpegLoader = new JpegLoader(this, this._frame);
        }
        this._jpegLoader.openDialog(new LatLonRectangle(this._track.getLatRange(), this._track.getLonRange()));
    }

    public void saveFile() {
        if (this._track == null) {
            this.showErrorMessage("error.save.dialogtitle", "error.save.nodata");
        } else {
            if (this._fileSaver == null) {
                this._fileSaver = new FileSaver(this, this._frame);
            }
            char c = ',';
            if (this._fileLoader != null) {
                c = this._fileLoader.getLastUsedDelimiter();
            }
            this._fileSaver.showDialog(c);
        }
    }

    public void exit() {
        this._frame.toFront();
        this._frame.requestFocus();
        Object[] objectArray = new Object[]{I18nManager.getText("button.exit"), I18nManager.getText("button.cancel")};
        if (this.hasDataUnsaved() && JOptionPane.showOptionDialog(this._frame, I18nManager.getText("dialog.exit.unsaveddata.text"), I18nManager.getText("dialog.exit.confirm.title"), 0, 2, null, objectArray, objectArray[1]) != 0) {
            return;
        }
        if (this._config.hasUnsavedChanges() && JOptionPane.showOptionDialog(this._frame, I18nManager.getText("dialog.exit.unsavedsettings.text"), I18nManager.getText("dialog.exit.confirm.title"), 0, 2, null, objectArray, objectArray[1]) != 0) {
            return;
        }
        if (this._config.getConfigBoolean("prune.autosavesettings")) {
            new SaveConfig(this).silentSave();
        }
        System.exit(0);
    }

    public void selectNone() {
        this._trackInfo.getSelection().clearAll();
        this._trackInfo.clearAllMarkers();
    }

    public void addRecentFile(File file, boolean bl) {
        this._config.getRecentFileList().addFile(new RecentFile(file, bl));
        UpdateMessageBroker.informSubscribers(64);
        if (bl && this.getTrackInfo().getTrack().hasSingleSourceFile()) {
            this.informDataSaved();
        }
    }

    public void informDataLoadComplete() {
        this._trackInfo.clearFileInfo();
        UpdateMessageBroker.informSubscribers(64);
        this.loadNextItem(true);
    }

    private void loadNextItem(boolean bl) {
        new Thread(() -> {
            this.checkForMultipleMediaDomains();
            while (!this._itemsToLoad.isEmpty()) {
                ItemToLoad itemToLoad = this._itemsToLoad.remove(0);
                if (itemToLoad.isDataFile()) {
                    if (this._fileLoader == null) {
                        this._fileLoader = new FileLoader(this);
                    }
                    this._fileLoader.openFile(itemToLoad.getDataFile(), bl);
                    return;
                }
                if (itemToLoad.isUrl()) {
                    this.getLinkedMediaLoader().loadFromUrl(itemToLoad.getUrl(), itemToLoad.getPoint(), itemToLoad.getBlockStatus());
                    return;
                }
                if (!itemToLoad.isArchivedFile()) continue;
                this.getLinkedMediaLoader().loadFromArchive(itemToLoad.getArchiveFile(), itemToLoad.getItemPath(), itemToLoad.getPoint());
                return;
            }
        }).start();
    }

    private LinkedMediaLoader getLinkedMediaLoader() {
        if (this._linkedMediaLoader == null) {
            this._linkedMediaLoader = new LinkedMediaLoader(this);
        }
        return this._linkedMediaLoader;
    }

    private void checkForMultipleMediaDomains() {
        HashSet<String> hashSet = new HashSet<String>();
        for (ItemToLoad itemToLoad : this._itemsToLoad) {
            if (!itemToLoad.isUrl() || itemToLoad.getBlockStatus() != ItemToLoad.BlockStatus.NOT_ASKED) continue;
            String string = itemToLoad.getUrl().getHost();
            if (this.getLinkedMediaLoader().isDomainKnown(string)) continue;
            hashSet.add(string);
        }
        if (hashSet.size() < 3) {
            return;
        }
        new BlockMultipleMediaDialog((Frame)this._frame, hashSet, this._itemsToLoad).setVisible(true);
    }

    public void saveExif() {
        ExifSaver exifSaver = new ExifSaver(this._frame, this._config.getConfigString("prune.exiftoolpath"));
        exifSaver.saveExifInformation(this._trackInfo.getPhotoList());
    }

    public void informDataSaved() {
        this._lastSavePosition = this._undoStack.size();
    }

    public void beginUndo() {
        if (this._undoStack.isEmpty()) {
            JOptionPane.showMessageDialog(this._frame, I18nManager.getText("dialog.undo.none.text"), I18nManager.getText("dialog.undo.none.title"), 1);
        } else {
            new UndoManager(this, this._frame).show(this.getUndoStack());
        }
    }

    public void clearUndo() {
        if (this._undoStack == null || this._undoStack.isEmpty()) {
            return;
        }
        boolean bl = this.hasDataUnsaved();
        int n = JOptionPane.showConfirmDialog(this._frame, I18nManager.getText("dialog.clearundo.text"), I18nManager.getText("dialog.clearundo.title"), 0);
        if (n == 0) {
            this._undoStack.clear();
            this._lastSavePosition = bl ? -1 : 0;
            UpdateMessageBroker.informSubscribers();
        }
    }

    public void undoActions(int n) {
        try {
            int n2 = 0;
            while (n2 < n) {
                Command command = this._undoStack.popCommand();
                this._redoStack.add(command);
                command.getInverse().execute(this._trackInfo);
                ++n2;
            }
            String string = n == 1 ? I18nManager.getText("confirm.undo.single") : I18nManager.getTextWithNumber("confirm.undo.multi", n);
            UpdateMessageBroker.informSubscribers(string);
        }
        catch (EmptyStackException emptyStackException) {}
        UpdateMessageBroker.informSubscribers();
    }

    public void beginRedo() {
        if (!this._redoStack.isEmpty()) {
            new RedoManager(this, this._frame).show(this._redoStack);
        }
    }

    public void redoActions(int n) {
        try {
            int n2 = 0;
            while (n2 < n) {
                Command command = this._redoStack.popCommand();
                this._undoStack.add(command);
                command.execute(this._trackInfo);
                ++n2;
            }
            String string = n == 1 ? I18nManager.getText("confirm.redo.single") : I18nManager.getTextWithNumber("confirm.redo.multi", n);
            UpdateMessageBroker.informSubscribers(string);
        }
        catch (EmptyStackException emptyStackException) {}
        UpdateMessageBroker.informSubscribers();
    }

    public DataStatus getCurrentDataStatus() {
        return new DataStatus(this._undoStack.size(), this._undoStack.getNumUndos());
    }

    public void showErrorMessage(String string, String string2) {
        JOptionPane.showMessageDialog(this._frame, I18nManager.getText(string2), I18nManager.getText(string), 0);
    }

    public void showErrorMessageNoLookup(String string, String string2) {
        JOptionPane.showMessageDialog(this._frame, string2, I18nManager.getText(string), 0);
    }

    public void setViewport(Viewport viewport) {
        this._viewport = viewport;
    }

    public Viewport getViewport() {
        return this._viewport;
    }

    public void setSidebarController(SidebarController sidebarController) {
        this._sidebarController = sidebarController;
    }

    public void toggleSidebars() {
        if (this._sidebarController != null) {
            this._sidebarController.toggle();
        }
    }

    public AppMode getCurrentMode() {
        return this._appMode;
    }

    public void setCurrentMode(AppMode appMode) {
        this._appMode = appMode;
    }

    public Config getConfig() {
        return this._config;
    }

    public IconManager getIconManager() {
        return this._iconManager;
    }

    public static enum AppMode {
        NORMAL,
        DRAWRECT_INSIDE,
        DRAWRECT_OUTSIDE;

    }
}

