/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.colour;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public abstract class WaypointSymbolPainter {
    public static Image paintSymbol(ImageIcon imageIcon, Color color) {
        if (imageIcon == null || imageIcon.getImage() == null) {
            return null;
        }
        Image image = imageIcon.getImage();
        if (color == null) {
            return image;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.getGraphics().drawImage(image, 0, 0, n, n2, null);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                bufferedImage.setRGB(n3, n4, WaypointSymbolPainter.paintPixel(bufferedImage.getRGB(n3, n4), color));
                ++n4;
            }
            ++n3;
        }
        return bufferedImage;
    }

    private static int paintPixel(int n, Color color) {
        int n2 = n & 0xFF000000;
        int n3 = (n & 0xFF0000) * color.getRed() / 255 & 0xFF0000;
        int n4 = (n & 0xFF00) * color.getGreen() / 255 & 0xFF00;
        int n5 = (n & 0xFF) * color.getBlue() / 255 & 0xFF;
        return n2 | n3 | n4 | n5;
    }
}

