#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pipes-safe
version:              2.3.5
visibility:           public
id:                   pipes-safe-2.3.5-AQS9EM22OGW5P3zK1Hw1qX
key:                  pipes-safe-2.3.5-AQS9EM22OGW5P3zK1Hw1qX
license:              BSD-3-Clause
copyright:            2013, 2014 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             Safety for the pipes ecosystem
description:
    This package adds resource management and exception handling to the @pipes@
    ecosystem.

    Notable features include:

    * /Resource Safety/: Guarantee finalization using @finally@, @bracket@ and
    more

    * /Exception Safety/: Even against asynchronous exceptions!

    * /Laziness/: Only acquire resources when you need them

    * /Promptness/: Finalize resources early when you are done with them

    * /Native Exception Handling/: Catch and resume from exceptions inside pipes

    * /No Buy-in/: Mix resource-safe pipes with unmanaged pipes using @hoist@

category:             Control, Pipes, Error Handling
abi:                  e28fded4cdda84473f25feb54a59e780
exposed:              True
exposed-modules:      Pipes.Safe Pipes.Safe.Prelude
import-dirs:          /usr/lib/ghc-9.4.8/site-local/pipes-safe-2.3.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/pipes-safe-2.3.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/pipes-safe-2.3.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pipes-safe
hs-libraries:         HSpipes-safe-2.3.5-AQS9EM22OGW5P3zK1Hw1qX
depends:
    base-4.17.2.1 containers-0.6.7 exceptions-0.10.5
    monad-control-1.0.3.1-5KQQUvViYP35kwtWEUOPGs mtl-2.2.2
    pipes-4.3.16-LZfhFcVjMzIBhB4624UE5U
    primitive-0.9.1.0-1TuYyil4nabJdMHni5vWH transformers-0.5.6.2
    transformers-base-0.4.6-72fNkPW8m0RFmUAZLkd9QA

haddock-interfaces:   /usr/share/doc/haskell-pipes-safe/html/pipes-safe.haddock
haddock-html:         /usr/share/doc/haskell-pipes-safe/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

