#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 statistics
version:              0.16.4.0
visibility:           public
id:                   statistics-0.16.4.0-L0qCsLIUD0BVljpXxXTUe
key:                  statistics-0.16.4.0-L0qCsLIUD0BVljpXxXTUe
license:              BSD-2-Clause
copyright:            2009-2014 Bryan O'\''Sullivan
maintainer:           Alexey Khudaykov <alexey.skladnoy@gmail.com>
author:
    Bryan O'\''Sullivan <bos@serpentine.com>, Alexey Khudaykov <alexey.skladnoy@gmail.com>

homepage:             https://github.com/haskell/statistics
synopsis:             A library of statistical types, data, and functions
description:
    This library provides a number of common functions and types useful
    in statistics.  We focus on high performance, numerical robustness,
    and use of good algorithms.  Where possible, we provide
    references to the statistical literature.
    .
    The library'\''s facilities can be divided into four broad categories:
    .
    * Working with widely used discrete and continuous probability
      distributions.  (There are dozens of exotic distributions in use;
      we focus on the most common.)
    .
    * Computing with sample data: quantile estimation, kernel density
      estimation, histograms, bootstrap methods, significance testing,
      and regression and autocorrelation analysis.
    .
    * Random variate generation under several different distributions.
    .
    * Common statistical tests for significant differences between
      samples.

category:             Math, Statistics
abi:                  5996eb08db593637231250f4efbe6ecd
exposed:              True
exposed-modules:
    Statistics.Autocorrelation Statistics.ConfidenceInt
    Statistics.Correlation Statistics.Correlation.Kendall
    Statistics.Distribution Statistics.Distribution.Beta
    Statistics.Distribution.Binomial
    Statistics.Distribution.CauchyLorentz
    Statistics.Distribution.ChiSquared
    Statistics.Distribution.DiscreteUniform
    Statistics.Distribution.Exponential
    Statistics.Distribution.FDistribution Statistics.Distribution.Gamma
    Statistics.Distribution.Geometric
    Statistics.Distribution.Hypergeometric
    Statistics.Distribution.Laplace Statistics.Distribution.Lognormal
    Statistics.Distribution.NegativeBinomial
    Statistics.Distribution.Normal Statistics.Distribution.Poisson
    Statistics.Distribution.StudentT Statistics.Distribution.Transform
    Statistics.Distribution.Uniform Statistics.Distribution.Weibull
    Statistics.Function Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.Internal Statistics.Sample.KernelDensity
    Statistics.Sample.KernelDensity.Simple Statistics.Sample.Normalize
    Statistics.Sample.Powers Statistics.Test.Bartlett
    Statistics.Test.ChiSquared Statistics.Test.KolmogorovSmirnov
    Statistics.Test.KruskalWallis Statistics.Test.Levene
    Statistics.Test.MannWhitneyU Statistics.Test.StudentT
    Statistics.Test.Types Statistics.Test.WilcoxonT
    Statistics.Transform Statistics.Types

hidden-modules:
    Statistics.Distribution.Poisson.Internal Statistics.Internal
    Statistics.Test.Internal Statistics.Types.Internal

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/statistics-0.16.4.0
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/statistics-0.16.4.0
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/statistics-0.16.4.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-statistics
hs-libraries:         HSstatistics-0.16.4.0-L0qCsLIUD0BVljpXxXTUe
depends:
    aeson-2.2.0.0-C0AkopVKntgCgZgm8TP6Wj
    async-2.2.5-1ovq96REeQVKYsP5cduurl base-4.18.3.0 binary-0.8.9.1
    data-default-class-0.1.2.2-25gAM82RrwXGN749A1StTw deepseq-1.4.8.1
    dense-linear-algebra-0.1.0.0-7Hv2MWZDJJS49oCJBdSTRi
    math-functions-0.3.4.4-IOpsyV3H35o8lt7KgtSzED
    mwc-random-0.15.2.0-CLwcPUSMuPz6NyNuZ4xAID
    parallel-3.2.2.0-1WmOVBnIr281FxwaAYcL5u
    primitive-0.9.1.0-GYJhpUEcsq4755gfDRC2m0
    random-1.2.1.3-GswEfj1SZ276IcAtylwQ0f
    vector-0.13.2.0-BINMV7y6ibUKgFTnLXEi1A
    vector-algorithms-0.9.1.0-9oSUJdS2OniJFYmXwUWF9O
    vector-binary-instances-0.2.5.2-6uafN0eH5GC1WRTrKUzxT2
    vector-th-unbox-0.2.2-6c4w9gADDm25JTp84fYYl9

haddock-interfaces:   /usr/share/doc/haskell-statistics/html/statistics.haddock
haddock-html:         /usr/share/doc/haskell-statistics/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

