#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 stm-containers
version:              1.2.1.1
visibility:           public
id:                   stm-containers-1.2.1.1-6BYGKAGFx3Y8T8kqED0KO8
key:                  stm-containers-1.2.1.1-6BYGKAGFx3Y8T8kqED0KO8
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/stm-containers
synopsis:             Containers for STM
description:
    This library is based on an STM-specialized implementation of
    Hash Array Mapped Trie.
    It provides efficient implementations of @Map@, @Set@
    and other data structures,
    which starting from version @1@ perform even better than their counterparts from \"unordered-containers\",
    but also scale well on concurrent access patterns.
    .
    For details on performance of the library, which are a bit outdated, see
    <http://nikita-volkov.github.io/stm-containers/ this blog post>.

category:             Data Structures, STM, Concurrency
abi:                  cd690ab75a6cb900edc3fec27d609c26
exposed:              True
exposed-modules:
    StmContainers.Bimap StmContainers.Map StmContainers.Multimap
    StmContainers.Set

hidden-modules:       StmContainers.Prelude
import-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/stm-containers-1.2.1.1

library-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/stm-containers-1.2.1.1

library-dirs-static:
    /usr/lib/ghc-9.6.7.20250817/site-local/stm-containers-1.2.1.1

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-stm-containers
hs-libraries:         HSstm-containers-1.2.1.1-6BYGKAGFx3Y8T8kqED0KO8
depends:
    base-4.18.3.0 deferred-folds-0.9.18.7-GGtPYdhyksgqPqI0MXdZF
    focus-1.0.3.2-J0VAcfJ6pTp5Tko8mVYEkJ
    hashable-1.4.7.0-17jkMnZLQLs4o2IKp4JpPo
    list-t-1.0.5.7-I7lku1OueTi9UPL0QuaE9t
    stm-hamt-1.2.1.1-DL0LyZQgzPFEcRWhYxLmJZ transformers-0.6.1.0

haddock-interfaces:
    /usr/share/doc/haskell-stm-containers/html/stm-containers.haddock

haddock-html:         /usr/share/doc/haskell-stm-containers/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

