#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.43.1
visibility:           public
id:                   hledger-1.43.1-CaJOccJREd87ILNGxZ4rzg
key:                  hledger-1.43.1-CaJOccJREd87ILNGxZ4rzg
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  0fbdb9198968d2c52a317ff2b50b04f1
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Setup Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.43.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.43.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.43.1-CaJOccJREd87ILNGxZ4rzg
depends:
    Decimal-0.5.2-CZNgfQK6v3DFQrbNDQg9pR
    Diff-0.5-2tX1FyxWy6p7M2fvM0xekx
    aeson-2.1.2.1-3HLieqpkeG06w6MDAYdLLk
    ansi-terminal-1.0.2-HSq0v3QUl8T11Wgx1QLnTe base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.3-1SaGr9SWFYZ17MG1fTAOKi
    directory-1.3.7.1 extra-1.7.16-CyTEZvSfBxsKCwY9ZtJE7E
    filepath-1.4.2.2 githash-0.1.6.3-9GBeKMqGAcC72CXb0q8NgF
    hashable-1.4.7.0-KrA5CwhmktQ6Qu5a4JCqq7 haskeline-0.8.2
    hledger-lib-1.43.1-HwSG03UtR4s6N4N6SpQZca
    http-client-0.7.19-Iyp8kyAVyHs5ic3dfNFLTs
    http-types-0.12.4-3Rkn4NOOYhzvBVdRap5Ii
    lucid-2.11.20250303-GXZ1Ug6xZHn2LHsZiS8N0D
    math-functions-0.3.4.4-2n51o8reQfp27kUCJfBpt6
    megaparsec-9.7.0-A5HZG6HxQB028mYZSYROei
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    modern-uri-0.3.6.1-JBJV5aTOumIBv5mL5fEV1v mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.5-71D7aDzS2d23Ft8PQEnlRo
    req-3.13.4-8MYSwvN2C64IMGZPjpEzbr
    safe-0.3.21-JMKA2bKqr97GM6r3OADsOi
    shakespeare-2.1.7-8Tdsqxebqs756ICmE3o1IV
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5.2-BKpN9d8J2hIHwcKpwM8zsO
    temporary-1.3-Kn2M9G1H4VS6orEei4BtCV text-2.0.2
    text-ansi-0.3.0.1-AGnJwCa1prZKp3qa8NkpVn time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20.1-JRJBW0Nl9iEJULI134IWXM
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    utility-ht-0.0.17.2-FHHtVV4Pxq51WmhixLkkXy
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

