#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-iadd
version:              1.3.22
visibility:           public
id:                   hledger-iadd-1.3.22-KSOXtrd4BNNLL4HhW142ij
key:                  hledger-iadd-1.3.22-KSOXtrd4BNNLL4HhW142ij
license:              BSD-3-Clause
copyright:            2018 Hans-Peter Deifel
maintainer:           Hans-Peter Deifel <hpd@hpdeifel.de>
author:               Hans-Peter Deifel <hpd@hpdeifel.de>
homepage:             https://github.com/hpdeifel/hledger-iadd#readme
synopsis:             A terminal UI as drop-in replacement for hledger add
description:
    This is a terminal UI as drop-in replacement for hledger add.

    It improves in the following ways on hledger'\''s add command:

    * Interactive as-you-type completion for
    account names and descriptions with optional
    fuzzy matching.

    * Integrated calculator: Amounts can be written
    as simple sums with real-time feedback on the
    result.

    * All actions while entering a transaction can
    be undone

    * Configurable format for date input. Instead
    of @y\/m\/d@ it is also possible to use other
    formats like the german @d.m.y@.

category:             Finance, Console
abi:                  0c6f1c8c801af135b5a8dec1624c0a52
exposed:              True
exposed-modules:
    AmountParser Brick.Widgets.BetterDialog Brick.Widgets.Border.Utils
    Brick.Widgets.CommentDialog Brick.Widgets.Edit.EmacsBindings
    Brick.Widgets.HelpMessage Brick.Widgets.List.Utils
    Brick.Widgets.WrappedText ConfigParser Data.Time.Ext DateParser
    Model View

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/hledger-iadd-1.3.22
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/hledger-iadd-1.3.22
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/hledger-iadd-1.3.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-iadd
hs-libraries:         HShledger-iadd-1.3.22-KSOXtrd4BNNLL4HhW142ij
depends:
    base-4.18.3.0 brick-2.5-JOnWOQLcNQWCBERbPPQnG2 containers-0.6.7
    directory-1.3.8.5 free-5.2-GjBgjt73BB74JXsIg5MCCe
    hledger-lib-1.51.2-3BDuGcSS1L2Bebp30yTvL7
    megaparsec-9.7.0-6iSCkwAigkw2HX9j1KdNdR
    microlens-0.4.14.0-4ENPj0tHNR0GzcdT8Xo5Q8
    microlens-mtl-0.2.1.0-BPqflcywilRLKDKsRXDgDa
    microlens-th-0.4.3.17-F1IcXkuPeIB4kMaxwhk9vS
    optparse-applicative-0.18.1.0-BYVre8yzbBOKektbxJ0fjC text-2.0.2
    text-zipper-0.13-DWC4Z7JxMfcDWZvR9cCZxL time-1.12.2
    transformers-0.6.1.0
    unordered-containers-0.2.20.1-Kme465eYitW9JyEVR89fCg
    vector-0.13.2.0-BINMV7y6ibUKgFTnLXEi1A
    vty-6.2-24OTVSAh8AUKPMJVuGQjH5
    xdg-basedir-0.2.2-8wXUiy3FOfhLbgVUcQEub

haddock-interfaces:   /usr/share/doc/hledger-iadd/html/hledger-iadd.haddock
haddock-html:         /usr/share/doc/hledger-iadd/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

