/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.dict;

import com.oracle.graal.python.builtins.objects.common.ForeignHashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.PHashingCollection;
import com.oracle.graal.python.builtins.objects.dict.PHashingStorageIterator;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.truffle.api.object.Shape;

public abstract class PDictView
extends PythonBuiltinObject {
    private final Object dict;
    private final ForeignHashingStorage foreignHashingStorage;
    private final String name;

    public PDictView(Object clazz, Shape instanceShape, String name, PHashingCollection dict) {
        this(clazz, instanceShape, name, dict, null);
    }

    public PDictView(Object clazz, Shape instanceShape, String name, Object dict, ForeignHashingStorage foreignHashingStorage) {
        super(clazz, instanceShape);
        this.name = name;
        assert (dict != null);
        this.dict = dict;
        assert (foreignHashingStorage == null || foreignHashingStorage.foreignDict == dict);
        this.foreignHashingStorage = foreignHashingStorage;
    }

    public final Object getWrappedDict() {
        return this.dict;
    }

    public final HashingStorage getWrappedStorage() {
        if (this.foreignHashingStorage != null) {
            return this.foreignHashingStorage;
        }
        return ((PHashingCollection)this.dict).getDictStorage();
    }

    public String getName() {
        return this.name;
    }

    public static final class PDictItemsView
    extends PDictView {
        public PDictItemsView(Object clazz, Shape instanceShape, PHashingCollection dict) {
            super(clazz, instanceShape, "dict_items", dict);
        }

        public PDictItemsView(Object clazz, Shape instanceShape, Object dict, ForeignHashingStorage foreignHashingStorage) {
            super(clazz, instanceShape, "dict_items", dict, foreignHashingStorage);
        }
    }

    public static final class PDictItemIterator
    extends PBaseDictIterator {
        public PDictItemIterator(Object clazz, Shape instanceShape, HashingStorageNodes.HashingStorageIterator iterator, HashingStorage hashingStorage, int initialSize) {
            super(clazz, instanceShape, iterator, hashingStorage, initialSize);
        }
    }

    public static final class PDictValuesView
    extends PDictView {
        public PDictValuesView(Object clazz, Shape instanceShape, PHashingCollection dict) {
            super(clazz, instanceShape, "dict_values", dict);
        }

        public PDictValuesView(Object clazz, Shape instanceShape, Object dict, ForeignHashingStorage foreignHashingStorage) {
            super(clazz, instanceShape, "dict_values", dict, foreignHashingStorage);
        }
    }

    public static final class PDictValueIterator
    extends PBaseDictIterator {
        public PDictValueIterator(Object clazz, Shape instanceShape, HashingStorageNodes.HashingStorageIterator iterator, HashingStorage hashingStorage, int initialSize) {
            super(clazz, instanceShape, iterator, hashingStorage, initialSize);
        }
    }

    public static final class PDictKeysView
    extends PDictView {
        public PDictKeysView(Object clazz, Shape instanceShape, PHashingCollection dict) {
            super(clazz, instanceShape, "dict_keys", dict);
        }

        public PDictKeysView(Object clazz, Shape instanceShape, Object dict, ForeignHashingStorage foreignHashingStorage) {
            super(clazz, instanceShape, "dict_keys", dict, foreignHashingStorage);
        }
    }

    public static final class PDictKeyIterator
    extends PBaseDictIterator {
        public PDictKeyIterator(Object clazz, Shape instanceShape, HashingStorageNodes.HashingStorageIterator iterator, HashingStorage hashingStorage, int initialSize) {
            super(clazz, instanceShape, iterator, hashingStorage, initialSize);
        }
    }

    public static abstract class PBaseDictIterator
    extends PHashingStorageIterator {
        public PBaseDictIterator(Object clazz, Shape instanceShape, HashingStorageNodes.HashingStorageIterator iterator, HashingStorage hashingStorage, int initialSize) {
            super(clazz, instanceShape, hashingStorage, iterator, initialSize);
        }
    }
}

