/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.nfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.RegexRootNode;
import com.oracle.truffle.regex.tregex.nfa.NFA;
import com.oracle.truffle.regex.tregex.nfa.NFAState;
import com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexNFAExecutorLocals;

public final class TRegexNFAExecutorNode
extends TRegexExecutorNode {
    private final NFA nfa;
    private final boolean searching;
    private final boolean trackLastGroup;
    private boolean dfaGeneratorBailedOut;

    private TRegexNFAExecutorNode(NFA nfa, int numberOfTransitions) {
        super(nfa.getAst(), numberOfTransitions);
        this.nfa = nfa;
        this.searching = !nfa.getAst().getFlags().isSticky() && !nfa.getAst().getRoot().startsWithCaret() && nfa.getInitialLoopBackTransition() != null;
        this.trackLastGroup = nfa.getAst().getOptions().getFlavor().usesLastGroupResultField();
    }

    private TRegexNFAExecutorNode(TRegexNFAExecutorNode copy) {
        super(copy);
        this.nfa = copy.nfa;
        this.searching = copy.searching;
        this.trackLastGroup = copy.trackLastGroup;
        this.dfaGeneratorBailedOut = copy.dfaGeneratorBailedOut;
    }

    public static TRegexNFAExecutorNode create(NFA nfa) {
        nfa.setInitialLoopBack(false);
        int numberOfTransitions = 0;
        for (int i = 0; i < nfa.getNumberOfTransitions(); ++i) {
            if (nfa.getTransitions()[i] == null) continue;
            nfa.getTransitions()[i].getGroupBoundaries().materializeArrays();
            ++numberOfTransitions;
        }
        return new TRegexNFAExecutorNode(nfa, numberOfTransitions);
    }

    @Override
    public TRegexNFAExecutorNode shallowCopy() {
        return new TRegexNFAExecutorNode(this);
    }

    public NFA getNFA() {
        return this.nfa;
    }

    public void notifyDfaGeneratorBailedOut() {
        this.dfaGeneratorBailedOut = true;
    }

    @Override
    public String getName() {
        return "nfa";
    }

    @Override
    public boolean isForward() {
        return true;
    }

    @Override
    public boolean isTrivial() {
        return false;
    }

    @Override
    public boolean writesCaptureGroups() {
        return true;
    }

    @Override
    public int getNumberOfStates() {
        return this.nfa.getNumberOfStates();
    }

    @Override
    public TRegexExecutorLocals createLocals(TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo, int index) {
        return new TRegexNFAExecutorLocals(input, fromIndex, maxIndex, regionFrom, regionTo, index, this.getNumberOfCaptureGroups(), this.nfa.getNumberOfStates(), this.trackLastGroup);
    }

    @Override
    public Object execute(VirtualFrame frame, TRegexExecutorLocals abstractLocals, TruffleString.CodeRange codeRange) {
        NFAState unAnchoredInitialState;
        TRegexNFAExecutorLocals locals = (TRegexNFAExecutorLocals)abstractLocals;
        CompilerDirectives.ensureVirtualized((Object)locals);
        int offset = this.rewindUpTo(locals, locals.getRegionFrom(), this.nfa.getAnchoredEntry().length - 1, codeRange);
        NFAState anchoredInitialState = this.nfa.getAnchoredEntry()[offset] == null ? null : this.nfa.getAnchoredEntry()[offset].getTarget();
        NFAState nFAState = unAnchoredInitialState = this.nfa.getUnAnchoredEntry()[offset] == null ? null : this.nfa.getUnAnchoredEntry()[offset].getTarget();
        if (anchoredInitialState != unAnchoredInitialState && this.inputAtBegin(locals)) {
            locals.addInitialState(anchoredInitialState.getId());
        }
        if (unAnchoredInitialState != null) {
            locals.addInitialState(unAnchoredInitialState.getId());
        }
        if (locals.curStatesEmpty()) {
            return null;
        }
        while (true) {
            if (this.dfaGeneratorBailedOut && CompilerDirectives.hasNextTier()) {
                locals.incLoopCount(this);
            }
            if (CompilerDirectives.inInterpreter()) {
                RegexRootNode.checkThreadInterrupted();
            }
            if (CompilerDirectives.injectBranchProbability((double)0.99, (boolean)this.inputHasNext(locals))) {
                this.findNextStates(locals, codeRange);
                if (CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (locals.successorsEmpty() && (!this.searching || locals.hasResult()) ? 1 : 0) != 0)) {
                    return locals.getResult();
                }
            } else {
                this.findNextStatesAtEnd(locals);
                return locals.getResult();
            }
            locals.nextState();
            this.inputAdvance(locals);
        }
    }

    private void findNextStates(TRegexNFAExecutorLocals locals, TruffleString.CodeRange codeRange) {
        int c = this.inputReadAndDecode(locals, codeRange);
        while (CompilerDirectives.injectBranchProbability((double)0.99, (boolean)locals.hasNext())) {
            this.expandState(locals, locals.next(), c, false);
            if (!CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (boolean)locals.isResultPushed())) continue;
            return;
        }
        if (CompilerDirectives.injectBranchProbability((double)0.99, (this.searching && !locals.hasResult() && locals.getIndex() > locals.getFromIndex() ? 1 : 0) != 0)) {
            this.expandState(locals, this.nfa.getInitialLoopBackTransition().getTarget().getId(), c, true);
        }
    }

    private void expandState(TRegexNFAExecutorLocals locals, int stateId, int c, boolean isLoopBack) {
        NFAState state = this.nfa.getState(stateId);
        for (int i = 0; i < TRegexNFAExecutorNode.maxTransitionIndex(state); ++i) {
            NFAStateTransition t = ((NFAStateTransition[])state.getSuccessors())[i];
            int targetId = t.getTarget().getId();
            int markIndex = targetId >> 6;
            long markBit = 1L << targetId;
            if (t.getTarget().isAnchoredFinalState(true) || (locals.getMarks()[markIndex] & markBit) != 0L) continue;
            long[] lArray = locals.getMarks();
            int n = markIndex;
            lArray[n] = lArray[n] | markBit;
            if (t.getTarget().isUnAnchoredFinalState(true)) {
                locals.pushResult(t, !isLoopBack);
                return;
            }
            if (!t.getCodePointSet().contains(c)) continue;
            locals.pushSuccessor(t, !isLoopBack);
            if (!t.getTarget().hasUnGuardedTransitionToUnAnchoredFinalState(true)) continue;
            return;
        }
    }

    private static int maxTransitionIndex(NFAState state) {
        return state.hasUnGuardedTransitionToUnAnchoredFinalState(true) ? state.getTransitionToUnAnchoredFinalStateId(true) + 1 : ((NFAStateTransition[])state.getSuccessors()).length;
    }

    private void findNextStatesAtEnd(TRegexNFAExecutorLocals locals) {
        while (CompilerDirectives.injectBranchProbability((double)0.99, (boolean)locals.hasNext())) {
            TRegexNFAExecutorNode.expandStateAtEnd(locals, this.nfa.getState(locals.next()), false);
            if (!CompilerDirectives.injectBranchProbability((double)0.010000000000000009, (boolean)locals.isResultPushed())) continue;
            return;
        }
        if (this.searching && CompilerDirectives.injectBranchProbability((double)0.99, (!locals.hasResult() && locals.getIndex() > locals.getFromIndex() ? 1 : 0) != 0)) {
            TRegexNFAExecutorNode.expandStateAtEnd(locals, this.nfa.getInitialLoopBackTransition().getTarget(), true);
        }
    }

    private static void expandStateAtEnd(TRegexNFAExecutorLocals locals, NFAState state, boolean isLoopBack) {
        if (state.hasUnGuardedTransitionToFinalState(true)) {
            locals.pushResult(state.getFirstTransitionToFinalState(true), !isLoopBack);
        }
    }
}

