/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyTupleSizeNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyTupleSizeNode
extends PNodeWithContext {
    public static int executeUncached(Object tuple) {
        return PyTupleSizeNodeGen.getUncached().execute(null, tuple);
    }

    public abstract int execute(Node var1, Object var2);

    @Specialization
    static int size(PTuple tuple) {
        return tuple.getSequenceStorage().length();
    }

    @Specialization(guards={"isTupleSubtype(tuple, inliningTarget, getClassNode, isSubtypeNode)"}, limit="1")
    @HostCompilerDirectives.InliningCutoff
    static int sizeNative(Node inliningTarget, PythonAbstractNativeObject tuple, @Cached GetClassNode getClassNode, @Cached(inline=false) IsSubtypeNode isSubtypeNode, @Cached(inline=false) CStructAccess.ReadI64Node getSize) {
        return PythonUtils.toIntError(getSize.readFromObj(tuple, CFields.PyVarObject__ob_size));
    }

    @HostCompilerDirectives.InliningCutoff
    @Fallback
    static int size(Object obj, @Bind Node inliningTarget) {
        throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC_S, "PyTuple_Size");
    }

    protected boolean isTupleSubtype(Object obj, Node inliningTarget, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
        return isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PTuple);
    }
}

