/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.database;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.Utility;
import us.fatehi.utility.UtilityLogger;
import us.fatehi.utility.string.StringFormat;

public final class DatabaseUtility {
    private static final Logger LOGGER = Logger.getLogger(DatabaseUtility.class.getName());

    public static Connection checkConnection(Connection connection) throws SQLException {
        try {
            Objects.requireNonNull(connection, "No database connection provided");
            if (connection.isClosed()) {
                throw new SQLException("Connection is closed");
            }
        }
        catch (NullPointerException e) {
            throw new SQLException(e);
        }
        return connection;
    }

    public static ResultSet checkResultSet(ResultSet resultSet) throws SQLException {
        try {
            Objects.requireNonNull(resultSet, "No result-set provided");
            if (resultSet.isClosed()) {
                throw new SQLException("Result-set is closed");
            }
        }
        catch (NullPointerException e) {
            throw new SQLException(e);
        }
        return resultSet;
    }

    public static Statement createStatement(Connection connection) throws SQLException {
        DatabaseUtility.checkConnection(connection);
        return connection.createStatement();
    }

    public static ResultSet executeSql(Statement statement, String sql) throws SQLException {
        if (statement == null) {
            return null;
        }
        if (Utility.isBlank(sql)) {
            LOGGER.log(Level.FINE, "No SQL provided", new RuntimeException("No SQL provided"));
            return null;
        }
        try {
            statement.clearWarnings();
            boolean hasResults = statement.execute(sql);
            new UtilityLogger(LOGGER).logSQLWarnings(statement);
            if (hasResults) {
                return statement.getResultSet();
            }
            int updateCount = statement.getUpdateCount();
            LOGGER.log(Level.FINE, new StringFormat("No results. Update count of %d for query: %s", updateCount, sql));
            return null;
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e, new StringFormat("Error executing SQL <%s>", sql));
            throw e;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static long executeSqlForLong(Connection connection, String sql) throws SQLException {
        try (Statement statement = DatabaseUtility.createStatement(connection);){
            long l;
            block14: {
                ResultSet resultSet = DatabaseUtility.executeSql(statement, sql);
                try {
                    l = DatabaseUtility.readResultsForLong(sql, resultSet);
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw new SQLException("%s%n%s".formatted(e.getMessage(), sql), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object executeSqlForScalar(Connection connection, String sql) throws SQLException {
        try (Statement statement = DatabaseUtility.createStatement(connection);){
            Object object;
            block14: {
                ResultSet resultSet = DatabaseUtility.executeSql(statement, sql);
                try {
                    object = DatabaseUtility.readResultsForScalar(sql, resultSet);
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return object;
        }
        catch (SQLException e) {
            throw new SQLException("%s%n%s".formatted(e.getMessage(), sql), e);
        }
    }

    public static Collection<Driver> getAvailableJdbcDrivers() throws SQLException {
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        try {
            ServiceLoader<Driver> serviceLoader = ServiceLoader.load(Driver.class);
            for (Driver driver : serviceLoader) {
                drivers.add(driver);
            }
        }
        catch (Throwable e) {
            throw new SQLException("Could not load database drivers: %s".formatted(e.getMessage()), e);
        }
        if (drivers.isEmpty()) {
            throw new SQLException("No database drivers are available");
        }
        return drivers;
    }

    public static long readResultsForLong(String sql, ResultSet resultSet) throws SQLException {
        Object longValue = DatabaseUtility.readResultsForScalar(sql, resultSet);
        if (longValue == null || !(longValue instanceof Number)) {
            throw new SQLException("Cannot get a long value result from SQL query");
        }
        return ((Number)longValue).longValue();
    }

    public static Object readResultsForScalar(String sql, ResultSet resultSet) throws SQLException {
        Object scalar;
        if (resultSet == null) {
            return null;
        }
        if (resultSet.getMetaData().getColumnCount() != 1) {
            throw new SQLException("Too many columns of data returned");
        }
        if (resultSet.next()) {
            scalar = resultSet.getObject(1);
            if (resultSet.wasNull()) {
                scalar = null;
            }
        } else {
            LOGGER.log(Level.WARNING, new StringFormat("No rows of data returned for query <%s>", sql));
            scalar = null;
        }
        if (resultSet.next()) {
            throw new SQLException("Too many rows of data returned");
        }
        return scalar;
    }

    public static List<String> readResultsVector(ResultSet results) throws SQLException {
        return DatabaseUtility.readResultsVector(results, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readResultsVector(ResultSet results, int columnNumber) throws SQLException {
        ArrayList<String> values = new ArrayList<String>();
        if (results == null || columnNumber <= 0) {
            return values;
        }
        try {
            while (results.next()) {
                String value = results.getString(columnNumber);
                if (results.wasNull() || Utility.isBlank(value)) continue;
                values.add(value.trim());
            }
        }
        finally {
            results.close();
        }
        return values;
    }

    private DatabaseUtility() {
    }
}

