/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.sql.SQLException;
import org.firebirdsql.gds.ConnectionParameterBuffer;
import org.firebirdsql.gds.ParameterTagMapping;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.AbstractParameterConverter;
import org.firebirdsql.gds.ng.wire.WireDatabaseConnection;
import org.firebirdsql.gds.ng.wire.WireServiceConnection;
import org.firebirdsql.gds.ng.wire.auth.legacy.UnixCrypt;

public class V10ParameterConverter
extends AbstractParameterConverter<WireDatabaseConnection, WireServiceConnection> {
    private static final String LEGACY_PASSWORD_SALT = "9z";

    @Override
    protected void populateAuthenticationProperties(AbstractConnection<?, ?> connection, ConnectionParameterBuffer pb) throws SQLException {
        Object props = connection.getAttachProperties();
        ParameterTagMapping tagMapping = pb.getTagMapping();
        if (props.getUser() != null) {
            pb.addArgument(tagMapping.getUserNameTag(), props.getUser());
        }
        if (props.getPassword() != null) {
            pb.addArgument(tagMapping.getEncryptedPasswordTag(), UnixCrypt.crypt(props.getPassword(), LEGACY_PASSWORD_SALT).substring(2, 13));
        }
    }
}

